<?php

namespace Vendor\CustomSearch\Model;

use Magento\CatalogSearch\Model\ResourceModel\Fulltext\Collection\SearchResultApplierInterface;
use Magento\Framework\Api\Search\SearchResultInterface;
use Magento\Framework\Data\Collection;

class SearchResultApplier implements SearchResultApplierInterface
{
    private $collection;
    private $searchResult;
    private $size;
    private $currentPage;

    public function __construct(
        Collection $collection,
        SearchResultInterface $searchResult,
        int $size,
        int $currentPage
    ) {
        $this->collection = $collection;
        $this->searchResult = $searchResult;
        $this->size = $size;
        $this->currentPage = $currentPage;
    }

    public function apply()
    {
        $customProductIds = [];
    
        if (isset($_GET['q']) && isset($_SESSION['ids']) && is_array($_SESSION['ids'])) {
            $customProductIds = $_SESSION['ids'];
    
            // Sort and slice for pagination
            $totalItems = count($customProductIds);
            $maxAllowedPage = ceil($totalItems / $this->size);
            $currentPage = max(1, min($this->currentPage, $maxAllowedPage));
    
            $offset = ($currentPage - 1) * $this->size;
            $pagedIds = array_slice($customProductIds, $offset, $this->size);
    
            // Apply filters Magento-style
            $this->collection
                ->addAttributeToSelect('*')
                ->addAttributeToFilter('entity_id', ['in' => $pagedIds])
                ->setPageSize($this->size)
                ->setCurPage($currentPage);
    
            // Optional: filter by manufacturer
            if (isset($_GET['manufacturer']) && is_numeric($_GET['manufacturer'])) {
                $this->collection->addAttributeToFilter('manufacturer', (int)$_GET['manufacturer']);
            }
    
            // Maintain original order using FIELD()
            $orderList = implode(',', $pagedIds);
            $this->collection->getSelect()
                ->reset(\Magento\Framework\DB\Select::ORDER)
                ->order(new \Zend_Db_Expr("FIELD(e.entity_id, $orderList)"));
    
        } else {
            // Default search behavior
            $items = $this->sliceItems($this->searchResult->getItems(), $this->size, $this->currentPage);
            $ids = array_map(function ($item) {
                return (int)$item->getId();
            }, $items);
            
    
            $this->collection
                ->addFieldToFilter('entity_id', ['in' => $ids])
                ->setPageSize($this->size)
                ->setCurPage($this->currentPage);
    
            $orderList = implode(',', $ids);
            $this->collection->getSelect()
                ->reset(\Magento\Framework\DB\Select::ORDER)
                ->order(new \Zend_Db_Expr("FIELD(e.entity_id, $orderList)"));
        }
    }    

    private function sliceItems(array $items, int $size, int $currentPage): array
    {
        if ($size !== 0) {
            $itemsCount = count($items);
            $maxAllowedPage = ceil($itemsCount / $size);
            $currentPage = max(1, min($currentPage, $maxAllowedPage));
            $offset = $this->getOffset($currentPage, $size);
            $items = array_slice($items, $offset, $size);
        }

        return $items;
    }

    private function getOffset(int $pageNumber, int $pageSize): int
    {
        return ($pageNumber - 1) * $pageSize;
    }
}
